%LET SYSLAST=SBST2.EARNINGS;
%LET _CLIENTTASKLABEL='Buckets Macro Year Number';
%LET _CLIENTPROCESSFLOWNAME='Final';
%LET _CLIENTPROJECTPATH='X:\OPD\Hemmeter\SBST\Potential SSI Population2.egp';
%LET _CLIENTPROJECTPATHHOST='S2740R5';
%LET _CLIENTPROJECTNAME='Potential SSI Population2.egp';
%LET _SASPROGRAMFILE='';
%LET _SASPROGRAMFILEHOST='';

GOPTIONS ACCESSIBLE;
rsubmit sy56.spawner;

libname sbst2 'ais.p1252.$4598.sbst2';

data sbst2.dates (compress=yes keep=ssn dob_date dod_date);
	set sbst2.outcomes3;
	dob_date=mdy(1,1,1950); /*don't need actual date--only keeping years 2010+*/
	ssn=boan;
run;
proc sort data=sbst2.dates nodupkey; by ssn; run;


/*Buckets Macro Requirements
		inlib=input data library

		outlib=output data library (can be same as inlib)

		indata1=Buckets SAS data file from Sirisha

		indata2=File with: SSN DOB_DATE DOD_DATE

		outdata=Output file name

		maxyear=Maximum year in Buckets file.  Need to let Sirisha know to turn off the year suppression,
				i.e., that you want the most recent year's potentially incomplete data (if you do).

	*/

/*Input Data Library*/
		libname inlib  'ais.p1252.$4598.sbst2' ;

/*Output Data Library*/
		libname outlib  'ais.p1252.$4598.sbst2' ;

		libname sbst3 'ais.p1252.$4598.sbst3';

%MACRO buckets(indata1=,indata2=,maxyear=,outdata=);
/*Create variables want to sbst3 with*/
		data sbst3.pre_earn (keep=ssn year2 tot_income wage_income se_income def_comp);
		  set inlib.&indata1;
		  tot_income=sei_med+max(wage_tips_irs + def_cntr, wage_tips_ss, wage_tips_med);
		  wage_income=max(wage_tips_irs + def_cntr, wage_tips_ss, wage_tips_med);
		  se_income=sei_med;
		  def_comp=def_cntr;
		  format tot_income wage_income se_income def_comp dollar13.2;
		  year2=year;
		  *year2=input(year,4.);
		  if year2>&maxyear then delete;
		  if year2<2010 then delete;
		run;
	/*Sort this by ssn and year*/
		proc sort data=sbst3.pre_earn;
		  by ssn year2;
		run;

	/*Get some summary stuff*/
		proc summary data=sbst3.pre_earn sum;
		  var tot_income wage_income se_income def_comp;
		  by ssn year2;
		  output out=sbst3.sum_earnings sum=;
		run;

	/*File of only SSNs*/
		data sbst3.ssnonly;
			set inlib.&indata2 (keep=ssn dob_date dod_date);
		run;
		proc sort data=sbst3.ssnonly out=sbst3.vosrt nodupkey;
			by ssn;
		run;

	/*File of people with no earnings*/
		data sbst3.no_earnings;
			merge sbst3.sum_earnings (in=ina) sbst3.vosrt (keep=ssn in=inb);
			by ssn;
			if ^ina and inb;
			year2=1978;
			tot_income=0;
			wage_income=0;
			se_income=0;
			def_comp=0;
		run;
	/*Combine those with earnings with those without earnings*/
		data sbst3.add_no_earnings;
			set sbst3.sum_earnings sbst3.no_earnings;
		run;

		proc sort data=sbst3.add_no_earnings;
			by ssn year2;
		run;
	/*Replace missings with zeroes, as appropriate*/
		data sbst3.expand (drop=i j k detyr_d tinc_d winc_d sinc_d dcomp_d);
		  set sbst3.add_no_earnings (drop=_type_ _freq_);
		  by ssn year2;
		  retain i;
		  if first.ssn then i=1978;
		  detyr_d=year2;
		  tinc_d=tot_income;
		  winc_d=wage_income;
		  sinc_d=se_income;
		  dcomp_d=def_comp;
		  if year2 ne i then do j=i to year2-1;
			year2=j;
			tot_income=0;
			wage_income=0;
			se_income=0;
			def_comp=0;
			output;
			if detyr_d=j+1 then do;
				i=j+1;
				year2=detyr_d;
			end;
		  end;
		  if year2=i then do;
		  	year2=year2;
			tot_income=tinc_d;
			wage_income=winc_d;
			se_income=sinc_d;
			def_comp=dcomp_d;
			output;
		  end;
		  if last.ssn and detyr_d ne &maxyear then do k=detyr_d+1 to &maxyear;
			year2=k;
			tot_income=0;
			wage_income=0;
			se_income=0;
			def_comp=0;
			output;
		  end;
		  i+1;	
		  label se_income='Self-Employed Income'
		        tot_income='Total Income'
				wage_income='Wage Income'
				def_comp='Deferred Compensation'
				scramssn='Social Security Number'
				year2='Year that earnings were posted to MEF';
		run;
	/*Make SAS dates in the earnings data*/
		data sbst3.sasdate (drop=year2 year_num rename=(makedate=year2));
		  set sbst3.expand;
		  length year_num 4;
		  year_num=input(year2,4.);
		  makedate=mdy(1,1,year_num);
		  format makedate year4.;
		run;
		proc sort data=sbst3.sasdate; 
		  by ssn year2;
		run;

	/*Make sure there is a file with everybody (vosrt from above)*/
	/*and merge it in together with earnings*/
	/*Replace zeroes with missing, as appropriate*/

		data outlib.&outdata (compress=yes);
			merge sbst3.sasdate (in=ina) sbst3.vosrt;
			by ssn;
			if ina;
			if ((year(year2) gt year(dod_date)) and dod_date ne .) 
				OR (year(dob_date) gt year(year2)) then do;
				tot_income=.;
				wage_income=.;
				def_comp=.;
				se_income=.;
			end;

			if year2 ge mdy(1,1,2010);
		run;

%MEND buckets;

%buckets(indata1=earnings, indata2=dates, maxyear=2019, outdata=earnings_person)
run;

proc datasets library=sbst3 nolist;
	delete sasdate vosrt expand add_no_earnings pre_earn sum_earnings ssnonly no_earnings;
run; quit;


data sbst2.earnings_person2 (compress=yes keep=boan year tot_income);
	set sbst2.earnings_person;
	boan=ssn;
	year=year(year2);
run;

proc sort data=sbst2.earnings_person2; by boan year; run;

proc transpose data=sbst2.earnings_person2
	out=sbst2.earnings_person3
	prefix=earn;
	by boan;
	id year;
	var tot_income;
run;


endrsubmit;

GOPTIONS NOACCESSIBLE;
%LET _CLIENTTASKLABEL=;
%LET _CLIENTPROCESSFLOWNAME=;
%LET _CLIENTPROJECTPATH=;
%LET _CLIENTPROJECTPATHHOST=;
%LET _CLIENTPROJECTNAME=;
%LET _SASPROGRAMFILE=;
%LET _SASPROGRAMFILEHOST=;

